import os
import streamlit as st
from langchain.vectorstores import Chroma 
from langchain.embeddings import GooglePalmEmbeddings
from langchain.llms import GooglePalm
from langchain.chains import RetrievalQA

os.environ["GOOGLE_API_KEY"] = "AIzaSyAETvYdW8PHW0uEgXAmMFs0jcJCo5Ffzc8"

# Define your RAG-based language model here
def rag_language_model(query):
# Your code to generate the response using the RAG-based language model
    chrome_db = Chroma(persist_directory='../data/i3_crisp', embedding_function=GooglePalmEmbeddings())

    retriver = chrome_db.as_retriever()

    qa_chain = RetrievalQA.from_chain_type(
    llm=GooglePalm(), 
    chain_type="stuff", 
    retriever=retriver,
    return_source_documents=True
    )

    return qa_chain(query)

# Create the Streamlit app
def main():
    st.title("Plaksha QABot")
    # Get user input
    user_input = st.text_input("Enter your query:")

    if st.button("Generate Response"):
        # Call the RAG-based language model
        response = rag_language_model(user_input)
        # Display the response
        st.write("Response:", response['result'])

if __name__ == "__main__":
    main()


